# coding: utf-8

from __future__ import unicode_literals

import importlib

from cab.core.views import BaseView


class SourceView(BaseView):

    def get(self, request, source_id):
        module = importlib.import_module('cab.sources.' + source_id)
        return {
            source_id: module.RESOURCES
        }


class DataView(BaseView):

    def get(self, request):
        from cab.sources import stocks
        data = {}
        data.update(stocks.get_interesting_stocks())
        data.update(yndx_in_rub=stocks.get_yndx_rub_stock_price())
        return data
