# coding: utf-8

from __future__ import unicode_literals

import yenv

from cab.utils import env
from cab.utils import http
from cab.utils import helpers


URL = env.choose({
    'production': 'https://fb.yandex-team.ru',
    'testing': 'https://fb.test.yandex-team.ru',
})

API_URL = URL + '/api'
WEB_URL = URL

RESOURCES = {
    'user': API_URL + '/user',
    'request_feedback_web': WEB_URL + '/request/?suggested_persons={staff_id}'
}


@helpers.timeit
def get_user_info(auth):
    session = http.get_session(auth)
    headers = {}
    if yenv.type not in ('production', 'prestable'):
        headers['DEBUG-LOGIN'] = auth.login
    response = session.get(
        url=RESOURCES['user'],
        headers=headers,
    )
    if response.ok:
        return response.json()
    return {}
