# coding: utf-8

from __future__ import unicode_literals

import urlparse
import logging

from ids.lib import pagination
from ids.lib import cia
from ids.services.startrek2 import connector

from cab import utils


log = logging.getLogger(__name__)


WEB_URL = utils.env.choose({
    'production': 'https://st.yandex-team.ru',
    'testing': 'https://st.test.yandex-team.ru',
})
RESOURCES = {
    'issue_web': WEB_URL + '/{issue_key}',
}


# Коряво все это, но в startrek-client для каждого обращения к полю
# типа createdBy делается дополнительный запрос
class StConnector(connector.StConnector):

    plugins = (
        utils.auth.MultiAuthPlugin,
    )

    available_auth_types = (
        'session_id',
    )

    url_patterns = {
        'issues_api_search': '/v2/issues/_search'
    }

    def execute_request(self, method='get', resource=None, url_vars=None, **params):
        if resource == 'issues_api_search':
            method = 'post'
        return super(StConnector, self).execute_request(
            method, resource, url_vars, **params)

    def build_url(self, resource, url_vars):
        return super(connector.StConnector, self).build_url(resource, url_vars)

    def handle_response(self, response):
        return response


class StPage(pagination.Page):

    previous_page_url = None
    next_page_url = None
    results = None

    def set_page_attributes(self, data):
        prev_link = data.links.get('prev')
        next_link = data.links.get('next')
        self.previous_page_url = prev_link and prev_link['url']
        self.next_page_url = next_link and next_link['url']
        self.results = data.json()

    def __iter__(self):
        for obj in self.results:
            yield obj

    def __len__(self):
        return len(self.results)

    @property
    def num(self):
        if self.previous_page_url is None:
            return 1

        parsed_url = urlparse.urlparse(self.previous_page_url)
        query_params = urlparse.parse_qs(parsed_url.query)
        if 'page' in query_params:
            previous_page = int(query_params['page'][0])
        else:
            previous_page = 1
        return previous_page + 1


class StFetcher(cia.CIAFetcher):

    page_cls = StPage


@utils.helpers.timeit
def get_issues_by_query(auth, query, fields=None):
    conn = StConnector(auth=auth, user_agent='cab')
    fields = fields or 'key,summary'
    fetcher = StFetcher(
        connector=conn,
        path='issues_api_search',
        json={'query': query},
        params={'fields': fields},
    )
    return pagination.ResultSet(fetcher=fetcher)


def parse_name(name):
    try:
        first_name, last_name = name.rsplit(' ', 1)
    except ValueError:
        log.warning("Failed to parse name: '%s'", name)
        first_name = last_name = None
    return first_name, last_name
