# coding: utf-8

from __future__ import unicode_literals

from cache_utils import decorators as cache_decorators

from cab.utils import helpers


ONE_DAY_IN_SECONDS = 60 * 60 * 24
TEN_MINUTES_IN_SECONDS = 60 * 10


def cached_safe(*args, **kwargs):
    def wrapper(func):
        decorator = cache_decorators.cached(*args, **kwargs)
        decorator = helpers.fail_silently()(decorator(func))
        return decorator
    return wrapper


