# coding: utf-8

from __future__ import unicode_literals


def user(**kwargs):
    valid_fields = (
        'first_name',
        'last_name',
        'login',
        'display_name',
    )
    user_data = {}
    for key in valid_fields:
        if key in kwargs:
            user_data[key] = kwargs[key]
    return user_data


def robot_staff(**kwargs):
    robot = user(
        first_name='Общее',
        last_name='Благо',
        login='robot-staff',
    )
    robot.update(user(**kwargs))
    return robot


def robot_startrek(**kwargs):
    robot = user(
        first_name='Робот',
        last_name='Спок',
        login='robot-spock'
    )
    robot.update(user(**kwargs))
    return robot


def salary(event):
    return {
        'value': event['salarySum'],
        'currency': event['currency'],
    }


def grade(event):
    oebs_shitty_value = event.get('gradeName')
    if not oebs_shitty_value:
        return

    if '.' not in oebs_shitty_value:
        return

    sections = oebs_shitty_value.split('.')
    if len(sections) == 2:
        grid_type, level = sections
    elif len(sections) == 3:
        # https://st.yandex-team.ru/OEBSAPPR-1568#1484228210000
        grid_type, level, pro_level = sections
    else:
        return

    try:
        level = int(level)
    except ValueError:
        return

    return {
        'grid_type': grid_type,
        'level': level,
    }
