# coding: utf-8

from __future__ import unicode_literals

import collections


def get_nested(dict_data, key):
    path = key.split('.')
    value = dict_data
    try:
        for subkey in path:
            value = value[subkey]
    except KeyError:
        return
    else:
        return value


def flatify(dict_data):
    flat = {}
    for key, value in dict_data.items():
        if isinstance(value, dict):
            flat.update({
                key + '_' + subkey: subvalue
                for (subkey, subvalue) in flatify(value).items()
            })
        else:
            flat[key] = value
    return flat


def dictify(iterable, key='id', process_item=None):
    process_item = process_item or (lambda x: x)
    return {item[key]: process_item(item) for item in iterable}


def group_by_key(iterable, key):
    """
    типа itertools.groupby без предварительной сортировки
    """
    grouped = {}
    for item in iterable:
        grouper = item[key]
        grouper_items = grouped.setdefault(grouper, [])
        grouper_items.append(item)
    return grouped


class RangeDict(collections.OrderedDict):

    @classmethod
    def from_gapless_range(cls, data):
        return cls(sorted(data, key=lambda item: item[0]))

    def get(self, key, default=None):
        prev_key, prev_value = None, default
        for range_start, value in self.items():
            if key < range_start:
                return prev_value
            prev_key, prev_value = key, value
        return prev_value


def get_subdict(dict_data, keys, default=None):
    return {
        key: dict_data.get(key, default)
        for key in keys
    }


def update_existing_keys(dict_one, dict_two):
    for key, value in dict_one.items():
        if key in dict_two:
            dict_one[key] = dict_two[key]


def integerify_str_keys(dict_data):
    return {
        int(key): value
        for key, value in dict_data.items()
    }
