# coding: utf-8

from __future__ import unicode_literals


def make_xlsx_response(file_name, data):
    from datetime import date

    try:
        from cStringIO import StringIO
    except ImportError:
        from StringIO import StringIO

    import xlsxwriter
    from django import http

    stream = StringIO()

    with xlsxwriter.Workbook(stream) as wb:
        ws = wb.add_worksheet(name=file_name)
        for i, row in enumerate(data):
            for j, cell_data in enumerate(row):
                ws.write(i, j, cell_data)

    data = stream.getvalue()
    response = http.HttpResponse(
        content=data,
        content_type=''.join([
            'application/vnd',
            '.openxmlformats-officedocument',
            '.spreadsheetml.sheet; charset=utf-8',
        ]),
    )

    today = date.today().isoformat()
    response['Content-Disposition'] = (
        'attachment; filename="%s_%s.xlsx"' % (file_name, today)
    )
    response['Content-Length'] = len(data)
    return response
