# coding: utf-8

from __future__ import unicode_literals
from __future__ import absolute_import

from django.conf import settings


def get_session(auth=None):
    import requests
    from ids.utils import https
    session = https.get_secure_session()

    if auth is None:
        return session

    if auth.session_id:
        session.cookies = requests.utils.cookiejar_from_dict(
            {
                'Session_id': auth.session_id,
                'sessionid2': auth.session_id2,
            }
        )

    elif auth.oauth_token:
        session.headers['Authorization'] = 'OAuth ' + auth.oauth_token

    elif hasattr(settings, 'DEFAULT_OAUTH_TOKEN'):
        session.headers['Authorization'] = 'OAuth ' + settings.DEFAULT_OAUTH_TOKEN
    return session
