# coding: utf-8

import operator

from cab.utils import datetimes


def squash_by_key(iterable, key, squasher):
    """
    Объединяем дикты в отсортированной последовательности с одинаковым
    значением ключа key
    """
    squashed = []
    prev_key_value = None
    prev_item = None
    for item in iterable:
        current_key_value = item[key]
        if current_key_value and current_key_value == prev_key_value:
            squasher(prev_item, item)
        else:
            squashed.append(item)
        prev_key_value, prev_item = current_key_value, item
    return squashed
