# coding: utf-8

from __future__ import unicode_literals


def is_localizable(value):
    if not isinstance(value, dict):
        return False
    return set(value) == {'ru', 'en'}


def localized(data, lang='ru'):
    if isinstance(data, dict):
        result = {}
        for key, value in data.items():
            if is_localizable(value):
                result[key] = value[lang]
            elif isinstance(value, dict):
                result[key] = localized(value, lang)
            elif isinstance(value, (list, tuple)):
                result[key] = [localized(val, lang) for val in value]
            else:
                result[key] = value
    elif isinstance(data, (list, tuple)):
        result = [localized(item, lang) for item in data]
    else:
        result = data
    return result
