# coding: utf-8

from __future__ import unicode_literals

from ylog import context


class ContextLoggingMiddleware(object):

    def process_request(self, request):
        for key, value in {
            'login': request.auth and request.auth.login,
            'req_id': id(request),
        }.items():
            context.put_to_context(key, value)

    def process_response(self, request, response):
        for key in ('login', 'req_id'):
            context.pop_from_context(key)
        return response
