# coding: utf-8

from __future__ import unicode_literals

import math

from django import forms


class Paginator(object):

    def __init__(self, page, limit):
        self.page = page
        self.limit = limit
        self.result = None
        self.total = None

    def as_dict(self):
        return {
            'result': self.result,
            'pager': {
                'current': self.page,
                'total': int(math.ceil(float(self.total) / self.limit)),
            }
        }


def paginated(func):
    def deco(*args, **kwargs):
        response_data = func(*args, **kwargs)
        if isinstance(response_data, Paginator):
            return response_data.as_dict()
        return response_data
    return deco


class PaginatorFormMixin(forms.Form):

    DEFAULT_LIMIT = 50

    _page = forms.IntegerField(required=False, min_value=1)
    _limit = forms.IntegerField(required=False, min_value=1)

    def clean(self):
        cleaned_data = super(PaginatorFormMixin, self).clean()
        page = cleaned_data['_page'] or 1
        limit = cleaned_data['_limit'] or self.DEFAULT_LIMIT
        cleaned_data['paginator'] = Paginator(page, limit)
