# coding: utf-8

from __future__ import unicode_literals

import re


def camelcase_to_underscore(camelcased_string):
    """
    >>> camelcase_to_underscore('CamelCase')
    'camel_case'
    >>> camelcase_to_underscore('CamelCamelCase')
    'camel_camel_case'
    >>> camelcase_to_underscore('Camel2Camel2Case')
    'camel2_camel2_case'
    >>> camelcase_to_underscore('getHTTPResponseCode')
    'get_http_response_code'
    >>> camelcase_to_underscore('get2HTTPResponseCode')
    'get2_http_response_code'
    >>> camelcase_to_underscore('HTTPResponseCode')
    'http_response_code'
    >>> camelcase_to_underscore('HTTPResponseCodeXYZ')
    'http_response_code_xyz'
    """
    first_cap_re = re.compile('(.)([A-Z][a-z]+)')
    all_cap_re = re.compile('([a-z0-9])([A-Z])')

    s1 = first_cap_re.sub(r'\1_\2', camelcased_string)
    return all_cap_re.sub(r'\1_\2', s1).lower()


def join_integers(integers_list, separator=','):
    return separator.join(map(str, integers_list))
