# coding: utf-8

from __future__ import unicode_literals

from django import forms


class WidgetValidator(forms.Form):

    # в поле можно задать data_field_name и значение возьмется из другого поля
    def add_prefix(self, field_name):
        field = self.fields[field_name]
        if hasattr(field, 'data_field_name') and field.data_field_name:
            field_name = field.data_field_name
        return super(WidgetValidator, self).add_prefix(field_name)


class ValidatorFieldMixin(object):

    data_field_name = None

    def __init__(self, *args, **kwargs):
        self.data_field_name = kwargs.pop(
            'data_field_name', self.data_field_name)
        super(ValidatorFieldMixin, self).__init__(*args, **kwargs)

    def clean(self, value):
        super(ValidatorFieldMixin, self).clean(value)
        return self.post_handle(value)

    def post_handle(self, value):
        return value


class PersonFieldsMultipleChoiceField(
    ValidatorFieldMixin,
    forms.MultipleChoiceField,
):

    def __init__(self, *args, **kwargs):
        self.fields_list = kwargs.pop('fields_list', None)
        super(PersonFieldsMultipleChoiceField, self).__init__(*args, **kwargs)
        self.choices = [
            (x, x) for x in tuple(self.fields_list) + ('all',)
        ]

    def post_handle(self, value):
        super(PersonFieldsMultipleChoiceField, self).validate(value)
        if 'all' in value:
            return self.fields_list
        return sorted(value, key=lambda name: self.fields_list.index(name))


class LoginField(
    ValidatorFieldMixin,
    forms.CharField,
):
    pass
