# coding: utf-8

from __future__ import unicode_literals

import logging

from functools import wraps

from django import http


log = logging.getLogger(__name__)


def responding_json(view):
    @wraps(view)
    def decorated(*args, **kwargs):

        response = view(*args, **kwargs)
        if not isinstance(response, http.HttpResponse):
            response = http.JsonResponse(response, safe=False)
        return response
    return decorated


class CatchExceptionsMiddleware(object):

    def process_exception(self, request, exception):
        from cab.utils import strings

        logging.exception(
            'while handling %(method)s %(url)s',
            {
                'method': request.method,
                'url': request.build_absolute_uri(),
            }
        )

        code = strings.camelcase_to_underscore(exception.__class__.__name__)
        return http.JsonResponse(
            data={
                'message': code,
                'debug': str(exception.message),
            },
            status=400,
        )
