# coding: utf-8

from __future__ import unicode_literals

import sys
import importlib
import pkgutil
import inspect

from django.apps import AppConfig as DjangoAppConfig

from cab.core import widgets

default_app_config = 'cab.widgets.AppConfig'


class Registry(dict):

    def register(self, widget):
        self[widget.id] = widget


registry = Registry()


class AppConfig(DjangoAppConfig):
    name = 'cab.widgets'

    def ready(self):
        from cab.widgets import registry

        this_module = sys.modules[__name__]
        widget_modules = [
            importlib.import_module('cab.widgets.' + name)
            for _, name, _ in
            pkgutil.iter_modules(this_module.__path__)
        ]

        for module in widget_modules:
            for name, obj in inspect.getmembers(module):
                if inspect.isclass(obj) and issubclass(obj, widgets.BaseWidget):
                    registry.register(obj)
