# coding: utf-8

from __future__ import unicode_literals

from cab.core import widgets
from cab.sources import startrek_goals
from cab.utils import validators


class PersonStGoals(widgets.BaseEndpointHandler):

    class Validator(validators.WidgetValidator):
        login = validators.LoginField(required=False)

    def handle(self, data):
        login = data['login'] or self.auth.login
        person_goals = startrek_goals.get_important_goals(auth=self.auth, login=login)

        def _goal_sort_key(goal):
            return (
                -int(goal['goalImportance']['id']),
                goal.get('deadline') or 'STR_BIGGER_THAN_DATE',
                goal['assignee']['id'] != login,
            )

        person_goals.sort(key=_goal_sort_key)
        return map(startrek_goals.format_goal_for_response, person_goals)


class GoalsWidget(widgets.BaseWidget):

    id = 'goals'

    endpoints = {
        'root': {
            'regex': '/$',
            'handler': PersonStGoals,
        }
    }
