# coding: utf-8

from __future__ import unicode_literals

from cab.core import widgets
from cab.sources import wiki


tag = '/staff/cab/wiki-widgets/hr-head'


class InfoDefault(widgets.BaseEndpointHandler):

    def handle(self, data):
        wiki_text = wiki.get_page_markup(auth=self.auth, tag=tag)
        html = wiki.markup_to_html(wiki_text)
        return {
            'tag': tag,
            'content': html,
            'url': wiki.RESOURCES['page_web'].format(tag=tag),
        }


class Widget(widgets.BaseWidget):
    id = 'info'

    endpoints = {
        'default': {
            'regex': '/$',
            'handler': InfoDefault,
        }
    }
