# coding: utf-8

from __future__ import unicode_literals

from cab.core import widgets

from . import endpoints


class PersonsWidget(widgets.BaseWidget):
    id = 'persons'

    endpoints = {
        'persons_by_filter': {
            'regex': '/data/$',
            'handler': endpoints.persons.PersonsByFilter,
        },
        'persons_fields': {
            'regex': '/fields/$',
            'handler': endpoints.persons.PersonsWithFields,
        },
        'export': {
            'regex': '/export/$',
            'handler': endpoints.persons.PersonsWithFieldsExport,
        },
        'controls': {
            'regex': '/$',
            'handler': {
                'GET': endpoints.controls.PersonsControls,
                'POST': endpoints.choices.ChoicesChange,
            }
        },
    }


class PersonWidget(widgets.BaseWidget):
    id = 'person'

    endpoints = {
        'default': {
            'regex': '/$',
            'handler': endpoints.person.SinglePersonWithFields,
        }
    }
