# coding: utf-8
from __future__ import unicode_literals

import itertools
from collections import OrderedDict


NOT_SET = object()
FIELD_NO_DATA = None
FIELD_ACCESS_DENIED = 'nodata_access_denied'
FIELD_FETCH_ERROR = None
FIELD_PROCESS_ERROR = None

OPTIONS_DISPLAY_NAME = {
    'N1R': 'RSU',
    'N1U': 'RSU',
    'N2R': 'SHARE OPTIONS',
    'N2U': 'SHARE OPTIONS',
    'RS1': 'RSU',
    'SSR': 'SAR',
    'SSU': 'SAR',
}


STAFF_API_FIELDS_MAPPING = {
    'id': 'id',
    'first_name': 'name.first',
    'last_name': 'name.last',
    'work_phone': 'work_phone',
    'work_email': 'work_email',
    'gender': 'personal.gender',
    'birthday': 'personal.birthday',
    'join_at': 'official.join_at',
    'quit_at': 'official.quit_at',
    'is_dismissed': 'official.is_dismissed',
    'death_date': 'memorial.death_date',
    'position': 'official.position',
    'employment': 'official.employment',
    'office': 'location.office.name',
    'city': 'location.office.city.name',
    'organization': 'official.organization.name',
    'department': 'department_group',
    'superior': [
        'chief',
        'login',
    ]
}


PERSONS_AVAILABLE_FIELDS_GROUPED = OrderedDict([
    (
        'common', (
            'work_phone',
            'work_email',
            'birthday',
            'position',
            'last_activity',
            'join_at',
            'employment',
            'city',
            'office',
            'organization',
        ),
    ),
    (
        'gaps', (
            'vacation_days_accumulated',
            'vacation_days_planned',
            'vacation_days_used',
        ),
    ),
    (
        'review', (
            'goals_count',
            'key_goals_involvement',
            'grade',
            'reviews',
        ),
    ),
    (
        'money', (
            'salary',
            'fte',
            'last_salary_raise',
            'last_bonus_payment',
            'year_bonus_payment',
            'signup',
            'piecerate',
        ),
    ),
    (
        'forecast', (
            'salary_forecast',
            'bonus_forecast',
            'options_vesting_forecast_cost',
            'income_forecast',
        ),
    ),
])


PERSONS_AVAILABLE_FIELDS_FLAT = tuple(
    itertools.chain.from_iterable(
        PERSONS_AVAILABLE_FIELDS_GROUPED.values()
    )
)


PERSONS_DEFAULT_FIELDS = (
    'city',
    'position',
)


PERSON_CARD_REQUIRED_FIELDS = (
    'gender',
    'position',
    'department',
)

AVG_DAYS_IN_MONTH = 365.25 / 12
