# coding: utf-8

from __future__ import unicode_literals

from cab.core import widgets
from cab.widgets.persons import datafields
from cab.widgets.persons.endpoints import utils
from cab.utils import validators


class ChoicesChange(widgets.BaseEndpointHandler):

    class Validator(validators.WidgetValidator):
        fields = validators.PersonFieldsMultipleChoiceField(
            fields_list=datafields.ALL_BULK_FIELDS,
        )

    def handle(self, data):
        utils.remember_controls(
            auth=self.auth,
            persons_fields=data.get('fields'),
        )
        return {}
