# coding: utf-8

from __future__ import unicode_literals

from cab.core import widgets
from cab.sources import staff, staff_api, abc_api
from cab.utils import l10n, multifetch
from cab.widgets.persons import const
from cab.widgets.persons.endpoints import utils


class PersonsControls(widgets.BaseEndpointHandler):

    def handle(self, data):
        return {
            'filter_id': self.get_filter_id_select(),
            'fields': self.get_fields_select(),
        }

    def get_filter_id_select(self):
        args_dict = {
            'filters': (self.auth,),
            'deps': (
                self.auth,
                self.auth.uid,
                1,
            ),
            'vteams': (self.auth,),
        }

        data = multifetch.collect_data(
            env_prefix='controls',
            func=fetch,
            args_dict=args_dict,
        )

        if data['filters'].is_error:
            saved_filters = []
        else:
            saved_filters = data['filters'].value

        if data['deps'].is_error:
            deps = []
        else:
            deps = data['deps'].value

        if data['vteams'].is_error:
            vteams = []
        else:
            vteams = data['vteams'].value

        deps = [l10n.localized(dep['department']) for dep in deps]

        choices = []

        if deps:
            default_filter = {
                'label': 'Непосредственные подчиненные',
                'value': 'subordinates-direct',
            }
        else:
            default_filter = {
                'label': 'Моё подразделение',
                'value': 'department-%s' % self.auth.extra['department_id']
            }

        choices.append(default_filter)
        if len(deps) > 1:
            choices.append({
                'label': 'Все подчиненные',
                'value': 'subordinates-all',
            })

        choices.extend(
            [
                {
                    'label': saved_filter['name'],
                    'value': 'saved-%s' % saved_filter['id'],
                }
                for saved_filter in saved_filters
            ] + [
                {
                    'label': dep['name']['full'],
                    'value': 'department-%s' % dep['id'],
                }
                for dep in deps
            ] + [
                {
                    'label': 'Команда «%s»' % l10n.localized(vteam)['name'],
                    'value': 'service-%s' % vteam['slug'],
                }
                for vteam in vteams
            ]
        )

        remembered_controls = utils.get_remembered_controls(auth=self.auth)
        remembered_filter_id = remembered_controls['persons_filter_id']
        has_remembered = remembered_filter_id in (it['label'] for it in choices)
        chosen_filter_id = remembered_filter_id if has_remembered else default_filter['value']

        return {
            'name': 'filter_id',
            'type': 'choice',
            'value': chosen_filter_id,
            'choices': choices,
        }

    def get_fields_select(self):
        choices = [
            {
                'label': group,
                'options': [
                    {
                        'label': field,
                        'value': field,
                    }
                    for field in fields
                ]
            }
            for group, fields in const.PERSONS_AVAILABLE_FIELDS_GROUPED.items()
        ]
        remembered_controls = utils.get_remembered_controls(auth=self.auth)
        remembered_fields = remembered_controls['persons_fields']
        chosen_fields = remembered_fields or const.PERSONS_DEFAULT_FIELDS
        return {
            'type': "multiplechoice",
            'name': "fields",
            'value': chosen_fields,
            'choices': choices
        }


@multifetch.fetcher
def fetch(args):
    fetcher_id, func_args = args[0], args[1:]
    return globals()['fetch_' + fetcher_id](*func_args)


def fetch_filters(auth):
    return staff.get_filters(auth=auth)


def fetch_deps(auth, uid, depth):
    return staff_api.get_subordinate_departments(
        auth=auth,
        uid=uid,
        depth=depth
    )


def fetch_vteams(auth):
    return abc_api.get_subordinate_vteams(auth, login=auth.login)
