# coding: utf-8

from __future__ import unicode_literals

from cab.core import widgets
from cab.utils import validators
from cab.sources import staff_api
from cab.widgets.persons import datafields


class SinglePersonWithFields(widgets.BaseEndpointHandler):

    class Validator(validators.WidgetValidator):
        login = validators.LoginField(required=False)
        fields = validators.PersonFieldsMultipleChoiceField(
            fields_list=datafields.ALL_FIELDS
        )

    def handle(self, data):
        login = data['login'] or self.auth.login
        person_data = staff_api.get_person_data(login=login)
        person = {
            'login': person_data['login'],
            'id': person_data['id'],
        }
        datafields.add_data(
            auth=self.auth,
            persons=[person],
            fields=data['fields'],
        )
        return person
