from rest_framework import serializers

from .block import BlockSerializer


class WorkflowListSerializer(serializers.Serializer):
    id = serializers.CharField(max_length=100, source='guid')
    name = serializers.CharField(max_length=200)


class WorkflowDetailSerializer(serializers.Serializer):
    id = serializers.CharField(max_length=100, source='guid')
    name = serializers.CharField(max_length=200)
    description = serializers.CharField(max_length=1000, required=False)
    blocks = BlockSerializer(many=True, read_only=True)


class UidMixin(serializers.Serializer):
    uid = serializers.SerializerMethodField()

    def get_uid(self, *args, **kwargs):
        return str(self.context['request'].yauser.uid)


class WorkflowAdvertisingCampaignDataSerializer(UidMixin, serializers.Serializer):
    website = serializers.URLField()
    service_slug = serializers.CharField(default='wiki', read_only=True)
    org_id = serializers.IntegerField(required=False, allow_null=True)


class WorkflowSiteTestingDataSerializer(UidMixin, serializers.Serializer):
    website = serializers.URLField()
    service_slug = serializers.CharField(default='tracker', read_only=True)
    org_id = serializers.IntegerField(required=False, allow_null=True)
