from django.conf.urls import url

from .views.workflow import (
    WorkflowListApiView,
    WorkflowDetailApiView,
    WorkflowStartApiView,
)

from .views.instance import (
    InstanceDetailApiView,
    InstanceRestartApiView,
)


app_name = 'intranet.compositor.src.api'

urlpatterns = [
    url(r'workflows/?$', WorkflowListApiView.as_view(), name='workflows-list'),
    url(r'workflows/(?P<workflow_slug>[\w-]+)/?$', WorkflowDetailApiView.as_view(), name='workflows-detail'),
    url(r'workflows/(?P<workflow_slug>[\w-]+)/start/?$', WorkflowStartApiView.as_view(), name='workflows-start'),
    url(r'instances/(?P<pk>[\w-]+)/?$', InstanceDetailApiView.as_view(), name='instance-detail'),
    url(r'instances/(?P<pk>[\w-]+)/restart/?$', InstanceRestartApiView.as_view(), name='instance-restart'),
]
