import boto3
import logging

from botocore import UNSIGNED
from botocore.client import Config

logger = logging.getLogger(__file__)


class MdsS3ApiClient:
    def __init__(self):
        self.client = boto3.client(
            service_name='s3',
            endpoint_url='https://s3.mds.yandex.net',
            verify=False,
            config=Config(signature_version=UNSIGNED)
        )

    def __getattr__(self, item):
        return getattr(self.client, item)

    def get_object_content(self, mds_path):
        *_, bucket, object_id = mds_path.split('/')
        try:
            response = self.client.get_object(
                Bucket=bucket,
                Key=object_id,
            )
        except self.client.exceptions.NoSuchKey:
            logger.warning(f'No such item: {mds_path}')
        else:
            return response['Body'].read()
