from django.http import JsonResponse

from django_yauth.middleware import YandexAuthBackendMiddleware
from django_yauth.user import YandexUser
from django.utils.deprecation import MiddlewareMixin


class YauthMiddleware(YandexAuthBackendMiddleware):

    def process_view(self, request, view_func, view_args, view_kwargs):
        if getattr(view_func, 'view_class', None) and getattr(view_func.view_class, 'yauth_check_exempt', False):
            return

        if not request.yauser:
            return JsonResponse(
                {'error': 'Invalid tvm2 ticket'},
                status=401,
            )

        if request.yauser.is_impersonated is False:
            # Пришли без пользовательского тикета - требуем заголовок X-UID
            x_uid = request.META.get('HTTP_X_UID')
            if not x_uid:
                JsonResponse(
                    {'error': 'X-UID or user_ticket is required'},
                    status=403,
                )
            request.yauser.uid = x_uid


class MockAuthMiddleware(MiddlewareMixin):
    def process_view(self, request, view_func, view_args, view_kwargs):
        setattr(request, 'yauser', YandexUser(uid=123))


def yauth_check_exempt(cls):
    cls.yauth_check_exempt = True
    return cls
