from django.conf.urls import re_path, include
from django.conf.urls.static import static
from django.conf import settings
from django.shortcuts import redirect
from django.urls import reverse

from .common_views import PingView

urlpatterns = [
    re_path(r'^api/v1/', include('intranet.compositor.src.api.urls', namespace='api_v1')),
    re_path(r'^ping/?', PingView.as_view(), name='ping'),
]


urlpatterns += static(
    settings.STATIC_URL,
    document_root=settings.STATIC_ROOT,
)

urlpatterns.append(re_path('^/?', lambda request: redirect(reverse('api_v1:workflows-list'), permanent=False)))
