from .exceptions import WikiInteractionException
from .. import settings
from .base import BaseClient


class WikiClient(BaseClient):
    tvm_client = settings.WIKI_TVM_CLIENT
    base_exception = WikiInteractionException

    def __init__(self, author_id: str, org_id: int):
        self.url = settings.WIKI_API_URL

        self.headers = {
            'X-Ya-Service-Ticket': self._get_ticket(),
            'X-ORG-ID': str(org_id),
        }

        self.params = {'uid': str(author_id)}

    def create_page(self, path: str, title: str, body: str):
        url = f'{self.url}{path}'

        data = {
            'title': title,
            'body': body
        }

        self._make_request(
            url=url,
            params=self.params,
            headers=self.headers,
            json_data=data,
            method='post',
        )
