import os

from tvm2 import TVM2
from tvmauth import BlackboxTvmId as BlackboxClientId

from intranet.compositor_processors.src.settings import (
    TVM2_DESTINATIONS,
    TVM2_CLIENTS,
    TVM2_CLIENT_ID,
)


class TVM2Error(Exception):
    pass


def get_tvm2_client():
    secret = os.environ.get('TVM2_SECRET')
    if not secret:
        raise TVM2Error(
            'Trying to initialize client, but TVM2_SECRET missing'
        )
    return TVM2(
        client_id=TVM2_CLIENT_ID,
        secret=secret,
        blackbox_client=BlackboxClientId.Prod,
        destinations=TVM2_DESTINATIONS,
        allowed_clients=[],
    )


def get_service_ticket(service):
    tvm2_client = get_tvm2_client()
    client_id = TVM2_CLIENTS.get(service)
    if not client_id:
        raise TVM2Error(f'Unknown client: {service}')
    service_tickets = tvm2_client.get_service_tickets(client_id)
    service_ticket = service_tickets.get(client_id)
    if not service_ticket:
        raise TVM2Error(f'Dont get service ticket for {service}')
    return service_ticket
