from ..clients.connect import ConnectClient
from ..logic.decorators import nirvana_command


CONNECT_DEFAULT_ORG_NAME = 'Yandex Setup Service'


@nirvana_command
def enable_service(org_id: int, uid: str, service_slug: str) -> None:
    connect_client = ConnectClient()
    connect_client.enable_service(org_id, uid, service_slug)


@nirvana_command
def disable_service(org_id: int, uid: str, service_slug: str) -> None:
    connect_client = ConnectClient()
    connect_client.disable_service(org_id, uid, service_slug)


@nirvana_command
def create_org(uid: str, org_id: int = None, org_name: str = CONNECT_DEFAULT_ORG_NAME,
               org_domain_name: str = '', org_language: str = 'ru') -> dict:
    if not org_id:
        connect_client = ConnectClient()
        result_data = connect_client.create_org(
            uid=uid,
            name=org_name,
            language=org_language,
            domain_name=org_domain_name,
        )
        org_id = result_data['org_id']

    return {'org_id': org_id}
