import logging

from ..logic.decorators import nirvana_command
from ..logic.tvm2_client import (
    get_service_ticket,
)
from ..settings import DIRECTORY_TVM_CLIENT


logger = logging.getLogger(__name__)

"""
Пример функции, которая запускается внутри кубика при
Y_PYTHON_ENTRY_POINT='intranet.compositor_processors.src.commands:do_smth_command'

Вызов в интерфейсе нирваны вот такой
./compositor.brick --input_file_path ${input['data']} --output_file_path ${output['result']}

Соответственно в i/o вкладке нужно настроить
data - input, json
result - output, json
"""


@nirvana_command
def do_smth(org_name: str, org_id: int = None) -> dict:
    logger.info('Пишу что-то в логи')

    # данные от других кубиков приходят в файлах, на вход
    # получаем уже непосредственно нужные аргументы обработанные
    # декоратором nirvana_command (там так же происходит проверка
    # наличия требуемых значений в json и их тип)
    data_to_write = {
        'org_name': org_name,
        'org_id': org_id,
        'some_data': 'привет'
    }

    # залогируем что-нибудь error
    logger.error('Something terrible happened')

    # пример получения сервисного тикета
    get_service_ticket(DIRECTORY_TVM_CLIENT)

    # Чтобы передать данные в другой кубик (опять же через
    # запись в файл) вернем их
    return data_to_write
