import logging

from ..logic.decorators import nirvana_command
from ..clients.wiki import WikiClient

logger = logging.getLogger(__name__)

DEFAULT_WIKI_PAGE_NAME = 'yandexsetupservice/testirovanie-{}'
DEFAULT_WIKI_PAGE_TITLE = 'Тестирование {}'
DEFAULT_WIKI_PAGE_BODY = ''


@nirvana_command
def create_wiki_page(uid: str, org_id: int, website: str, wiki_page_name: str = None,
                     wiki_page_title: str = None, wiki_page_body: str = None,
                     ) -> dict:
    """
    Функция создающая страницу на вики
    """

    wiki_page_body = wiki_page_body or DEFAULT_WIKI_PAGE_BODY
    wiki_page_title = wiki_page_title or DEFAULT_WIKI_PAGE_TITLE.format(website)
    wiki_page_name = wiki_page_name or DEFAULT_WIKI_PAGE_NAME.format(website)

    client = WikiClient(author_id=uid, org_id=org_id)
    client.create_page(
        path=wiki_page_name,
        title=wiki_page_title,
        body=wiki_page_body,
    )
    return {'wiki_page': wiki_page_name}
