import os

os.environ['YENV_NAME'] = 'other'

if not os.environ.get('YENV_TYPE'):
    os.environ['YENV_TYPE'] = 'testing'

import yenv

TRACKER_TVM_CLIENT = 'tracker'
WIKI_TVM_CLIENT = 'wiki'
DIRECTORY_TVM_CLIENT = 'directory'

TVM2_CLIENTS_MAP = {
    'testing': {
        DIRECTORY_TVM_CLIENT: '2000204',
        TRACKER_TVM_CLIENT: '2000181',
        WIKI_TVM_CLIENT: '2002684',
    },
    'production': {
        DIRECTORY_TVM_CLIENT: '2000205',
        TRACKER_TVM_CLIENT: '2000182',
        WIKI_TVM_CLIENT: '2002686',
    },
}

TVM2_CLIENTS = yenv.choose_key_by_type(TVM2_CLIENTS_MAP)

TVM2_DESTINATIONS = list(TVM2_CLIENTS.values())

TVM2_CLIENT_ID = yenv.choose_key_by_type(
    {
        'testing': '2016989',
        'production': '2016991',
    }
)

TRACKER_USERAGENT = yenv.choose_key_by_type(
    {
        'testing': 'compositor-test',
        'production': 'compositor',
    }
)

TRACKER_RETRY = 10

TRACKER_IDS_CONFIG = {
    'service': 'startrek2',
    'user_agent': TRACKER_USERAGENT,
    'api_version': 'service',
    'timeout': 10,
    'retries': TRACKER_RETRY,
    'retry_on_status': True,
}


TRACKER_ISSUE_TYPE_CONFIG = [
    {
        'issueType': 'task',
        'workflow': 'quickStartV2PresetWorkflow',
        'resolutions': ['wontFix'],
    }
]

DIRECTORY_HOST = yenv.choose_key_by_type(
    {
        'testing': 'https://api-internal-test.directory.ws.yandex.net',
        'production': 'https://api-internal.directory.ws.yandex.net',
    }
)

WIKI_API_URL = yenv.choose_key_by_type(
    {
        'testing': 'https://wiki-api.test.yandex.ru/_api/frontend/',
        'production': 'https://wiki-api.yandex.ru/_api/frontend/',
    }
)
