from django.db import migrations, models
import django.db.models.deletion
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        ('tags', '0004_add_is_active_field'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('core', '0021_alter_ca_name_choices'),
    ]

    operations = [
        migrations.CreateModel(
            name='Action',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('type', models.CharField(db_index=True, max_length=63, choices=[('cert_revoke', 'Revoke'), ('cert_hold', 'Hold'), ('cert_unhold', 'Unhold'),('tag_filter_add_user', 'TagFilter add user'), ('tag_filter_remove_user', 'TagFilter remove user'), ('tag_add_cert', 'CertificateTag add certificate'), ('tag_remove_cert', 'CertificateTag remove certificate')])),
                ('added', models.DateTimeField(auto_now_add=True)),
                ('description', models.CharField(max_length=127, null=True, blank=True)),
                ('certificate', models.ForeignKey(related_name='actions', on_delete=django.db.models.deletion.PROTECT, blank=True, to='core.Certificate', null=True)),
                ('tag', models.ForeignKey(related_name='actions', on_delete=django.db.models.deletion.PROTECT, blank=True, to='tags.CertificateTag', null=True)),
                ('tag_filter', models.ForeignKey(related_name='actions', on_delete=django.db.models.deletion.PROTECT, blank=True, to='tags.TagFilter', null=True)),
                ('user', models.ForeignKey(related_name='actions', on_delete=django.db.models.deletion.PROTECT, blank=True, to=settings.AUTH_USER_MODEL, null=True)),
            ],
        ),
    ]
