import collections

from django.db import models

from intranet.crt.actions.managers import ActionManager
from intranet.crt.constants import ACTION_TYPE
from intranet.crt.core.models import Certificate
from intranet.crt.tags.models import CertificateTag, TagFilter
from intranet.crt.users.models import CrtUser


class Action(models.Model):
    type = models.CharField(max_length=63, db_index=True)
    added = models.DateTimeField(auto_now_add=True, db_index=True)
    description = models.CharField(max_length=127, null=True, blank=True)
    certificate = models.ForeignKey(Certificate, related_name='actions', null=True, blank=True, on_delete=models.PROTECT)
    user = models.ForeignKey(CrtUser, related_name='actions', null=True, blank=True, on_delete=models.PROTECT)
    tag = models.ForeignKey(CertificateTag, related_name='actions', null=True, blank=True, on_delete=models.PROTECT)
    tag_filter = models.ForeignKey(TagFilter, related_name='actions', null=True, blank=True, on_delete=models.PROTECT)

    objects = ActionManager()

    def __str__(self):
        fields = collections.OrderedDict()
        if self.certificate is not None:
            fields['certificate'] = self.certificate.id
        if self.user is not None:
            fields['user'] = self.user.username
        if self.tag is not None:
            fields['tag'] = self.tag.name
        if self.tag_filter is not None:
            fields['tag_filter'] = self.tag_filter.name
        fields = ', '.join(['{}={}'.format(name, value) for name, value in fields.items()])

        return '<{s.type}({s.added:%Y-%m-%d %H:%M:%S}): {fields}>'.format(s=self, fields=fields)
