from rest_framework.exceptions import APIException, Throttled
from rest_framework import status
from django.utils.translation import ugettext_lazy as _


class BadRequest(APIException):
    status_code = status.HTTP_400_BAD_REQUEST
    default_detail = 'Bad request.'


class NotFound(APIException):
    status_code = status.HTTP_404_NOT_FOUND
    default_detail = 'Not found'


class ReplicationLag(Throttled):
    status_code = status.HTTP_404_NOT_FOUND
    default_detail = 'Object is not updated on replica yet.'


class PleaseRedirectToPassport(APIException):
    """Копия NotAuthenticated, которую не перехватывает DRF"""

    status_code = status.HTTP_401_UNAUTHORIZED
    default_detail = _('Authentication credentials were not provided.')
    default_code = 'not_authenticated'
