import re

from rest_framework import serializers


class BotikCertMixin(object):
    common_name_pattern = re.compile(r'^(?:[\w\d.]*tunnel[\w\d.]*\.[\d]{1,3}|[\w\d-]*homer\d*)$')

    def validate_common_name(self, common_name):
        # TODO: Нужно отдельное право выписывать botik-сертификаты
        if common_name is None:
            raise serializers.ValidationError('"common_name" field is required')

        cn_match = self.common_name_pattern.match(common_name)
        if cn_match is None:
            raise serializers.ValidationError(
                'Invalid common name: it does not match regex %s' % self.common_name_pattern.pattern
            )
        return '{}@botik.yandex.ru'.format(common_name)
