from django.conf import settings
from rest_framework import serializers

from intranet.crt.api.base.serializer_mixins.need_approve import NeedApproveCertMixin


class ClientServerMixin(NeedApproveCertMixin):
    @classmethod
    def check_common_name(self, common_name):
        for pattern in settings.CRT_CLIENT_SERVER_CN_PATTERNS:
            if pattern.match(common_name) is not None:
                return

        raise serializers.ValidationError('Invalid common name')

    def validate_request(self, csr):
        if csr is None:
            raise serializers.ValidationError('This field is required.')

        self.get_common_name(csr)

        return csr


class BankClientServerMixin(NeedApproveCertMixin):
    @classmethod
    def check_common_name(self, common_name):
        for pattern in settings.CRT_BANK_CLIENT_SERVER_CN_PATTERNS:
            if pattern.match(common_name) is not None:
                return

        raise serializers.ValidationError('Invalid common name')

    def validate_request(self, csr):
        if csr is None:
            raise serializers.ValidationError('This field is required.')

        self.get_common_name(csr)

        return csr
