import re

from rest_framework import serializers


class ImdmCertMixin(object):
    common_name_pattern = re.compile(r'^([\w._-]+)@(pda-)?ld\.yandex\.ru$')
    organizational_unit_pattern = re.compile(r'^MOBILE$')
    pc_serial_number_pattern = re.compile(r'^[A-Z0-9]{9,}$')

    def validate_pc_serial_number(self, pc_serial_number):
        if pc_serial_number is None:
            raise serializers.ValidationError('This field is required.')

        if self.pc_serial_number_pattern.match(pc_serial_number) is None:
            raise serializers.ValidationError('invalid field format')

        return pc_serial_number

    def validate_request(self, csr):
        if csr is None:
            raise serializers.ValidationError('This field is required.')

        self.get_organizational_unit(csr, require=True)
        common_name = self.get_common_name(csr)
        self.get_user_from_common_name(common_name)

        return csr

    def validate(self, attrs):
        attrs = super(ImdmCertMixin, self).validate(attrs)

        csr = attrs['request']
        common_name = self.get_common_name(csr)
        attrs['user'] = self.get_user_from_common_name(common_name)

        return attrs

    def pre_save(self):
        self.validated_data['requester'] = self._context['request'].user
        self.validated_data['requested_by_csr'] = 'request' in self.validated_data
