from rest_framework import serializers

from intranet.crt.api.base.serializer_mixins.host import HostsCertMixin, HostsRequiredCertMixin
from intranet.crt.core.models import Host


class MdbCertMixin(HostsRequiredCertMixin, HostsCertMixin):
    MDB_DOMAIN = '.db.yandex.net'

    def validate_common_name(self, common_name):
        if common_name and common_name.endswith(self.MDB_DOMAIN):
            return common_name
        else:
            raise serializers.ValidationError('Invalid common name')

    def postvalidate_common_name(self, attrs):
        if not attrs.get('hosts', None):
            self.fill_hosts_with_common_name(attrs)
        return attrs

    def postvalidate_hosts(self, attrs):
        hosts = [h.hostname for h in attrs.get('hosts', [])]

        self.check_required_hosts(hosts)

        non_domain_hosts = [h for h in hosts if not h.endswith(self.MDB_DOMAIN)]
        if non_domain_hosts:
            raise serializers.ValidationError(
                'Some hosts not belongs to mdb domain ({})'.format(', '.join(non_domain_hosts))
            )

        wildcards = [host for host in hosts if '*' in host]
        if wildcards:
            raise serializers.ValidationError('This certificate type does not support wildcard')

        self.fill_common_name_if_not_set(attrs)
        return attrs
