import copy

from django.conf import settings
from rest_framework import serializers

from intranet.crt.api.base.serializer_mixins.personal import PcCertMixin
from intranet.crt.constants import CERT_TYPE, CERT_STATUS
from intranet.crt.core.models import Certificate


class MobvpnCertMixin(PcCertMixin):
    def __init__(self, *args, **kwargs):
        if isinstance(kwargs.get('data'), dict) and 'secret' in kwargs['data']:
            kwargs['data'] = copy.deepcopy(kwargs['data'])
            self.secret = kwargs['data'].pop('secret')
        else:
            self.secret = None
        super(MobvpnCertMixin, self).__init__(*args, **kwargs)

    def validate_request(self, csr):
        if csr is None:
            raise serializers.ValidationError('This field is required.')

        common_name = self.get_common_name(csr)
        user = self.get_user_from_common_name(common_name)
        self.get_email(csr)

        if self.context['request'].user != user:
            raise serializers.ValidationError('Invalid user in common name')

        return csr

    def validate(self, attrs):
        attrs = super(MobvpnCertMixin, self).validate(attrs)

        attrs = self.prevalidate_pc_inum(attrs)

        if self.secret is None:
            raise serializers.ValidationError('Secret is required')

        if self.secret != settings.MOBVPN_SECRET_TOKEN:
            raise serializers.ValidationError('Invalid secret')

        queryset = Certificate.objects.filter(
            user=self.context['request'].user,
            type__name=CERT_TYPE.MOBVPN,
            status=CERT_STATUS.ISSUED,
        )

        if queryset.exists():
            raise serializers.ValidationError('У пользователя уже есть сертификат mobvpn.')

        return attrs
