import waffle

from intranet.crt.constants import CERT_STATUS
from intranet.crt.core.models import ApproveRequest
from intranet.crt.utils.startrek import create_st_issue_for_cert_approval


class NeedApproveCertMixin(object):
    def without_approve_perm(self):
        requester = self.context['request'].user
        return requester.has_perm('core.can_issue_without_approve')

    def pre_save(self):
        super(NeedApproveCertMixin, self).pre_save()

        # TODO: выпилить после тестирования в проде
        from intranet.crt.api.v1.certificates.serializers.specified import \
            ClientServerCertSerializer as V1ClientServerSerializer
        from intranet.crt.api.v1.certificates.serializers.specified import \
            BankClientServerCertSerializer as V1BankClientServerCertSerializer
        from intranet.crt.api.v2.certificates.serializers.specified import \
            ClientServerCertSerializer as V2ClientServerSerializer
        from intranet.crt.api.v2.certificates.serializers.specified import \
            BankClientServerCertSerializer as V2BankClientServerCertSerializer
        if (
            isinstance(self, (V1ClientServerSerializer, V2ClientServerSerializer))
            and not waffle.switch_is_active('client_server_should_be_approved')
        ) or (
            isinstance(self, (V1BankClientServerCertSerializer, V2BankClientServerCertSerializer))
            and not waffle.switch_is_active('bank_client_server_should_be_approved')
        ):
            return

        if self.without_approve_perm():
            return

        self.validated_data['status'] = CERT_STATUS.NEED_APPROVE

    def post_save(self):
        super(NeedApproveCertMixin, self).post_save()

        # TODO: выпилить после тестирования в проде
        from intranet.crt.api.v1.certificates.serializers.specified import \
            ClientServerCertSerializer as V1ClientServerSerializer
        from intranet.crt.api.v1.certificates.serializers.specified import \
            BankClientServerCertSerializer as V1BankClientServerCertSerializer
        from intranet.crt.api.v2.certificates.serializers.specified import \
            ClientServerCertSerializer as V2ClientServerSerializer
        from intranet.crt.api.v2.certificates.serializers.specified import \
            BankClientServerCertSerializer as V2BankClientServerCertSerializer
        if (
            isinstance(self, (V1ClientServerSerializer, V2ClientServerSerializer))
            and not waffle.switch_is_active('client_server_should_be_approved')
        ) or (
            isinstance(self, (V1BankClientServerCertSerializer, V2BankClientServerCertSerializer))
            and not waffle.switch_is_active('bank_client_server_should_be_approved')
        ):
            return

        if self.without_approve_perm():
            return

        issue = create_st_issue_for_cert_approval(self.instance)

        ApproveRequest.objects.create(certificate=self.instance, st_issue_key=issue.key)
