# coding: utf-8

from __future__ import absolute_import, unicode_literals

import re

from rest_framework import serializers


class PostamateCertMixin(object):
    CN_PATTERN = re.compile(r'^([A-Z0-9a-z\-]+)@market\.yandex$')

    def validate_common_name(self, common_name):
        if common_name and self.CN_PATTERN.match(common_name) is not None:
            return common_name
        else:
            raise serializers.ValidationError('Invalid common name')
