import re

from django.conf import settings
from rest_framework import serializers

from intranet.crt.utils.domain import get_domain_levels


class RcServerCertMixin(object):
    common_name_pattern = re.compile(r'^[\w.-]+$')

    def validate_common_name(self, common_name):
        if common_name is None:
            raise serializers.ValidationError('\'common_name\' field is required')

        cn_match = self.common_name_pattern.match(common_name)
        if cn_match is None:
            raise serializers.ValidationError('Invalid common name')

        domains = set(get_domain_levels(common_name))
        if not domains & settings.CRT_RC_SERVER_DOMAINS:
            raise serializers.ValidationError('Invalid common name')

        return common_name
