import re

from rest_framework import serializers

from intranet.crt.core.models import Certificate, Host


class SdcCertMixin(object):
    CN_PATTERN = re.compile(r'^[\w.-]+\.rover\.sdc\.yandex\.net$')

    def validate_common_name(self, common_name):
        if self.CN_PATTERN.match(common_name) is not None:
            self.common_name = common_name
            return common_name
        else:
            raise serializers.ValidationError('Invalid common name')

    def create(self, validated_data):
        hosts = [Host(hostname=self.common_name)] if self.common_name else None
        instance = Certificate(**validated_data)
        instance.save(hosts=hosts)
        return instance
