import ldap
import re
from rest_framework import serializers

from django.conf import settings

from intranet.crt.utils.ldap import get_username_by_dn
from intranet.crt.users.models import CrtUser


class TpmSmartcard1CCertMixin(object):
    common_name_pattern = re.compile(r'^([\w._-]+)@smartcard$')

    def validate_request(self, csr):
        if csr is None:
            raise serializers.ValidationError('This field is required.')
        req_dn_str = self.get_dn_str(csr)

        username = None
        error = None

        try:
            # Находим пользователя по DN в LDAP
            username = get_username_by_dn(req_dn_str)
            self.cerificate_user = CrtUser.objects.get(username=username)
        except ldap.NO_RESULTS_RETURNED:
            error = 'CSR Subject \'{}\' does not match any LDAP distinguishedName'.format(
                req_dn_str
            )
        except CrtUser.DoesNotExist:
            error = 'User {} is not found in CRT'.format(username)

        if error:
            raise serializers.ValidationError(
                error + '. Please contact {}/CERTOR'.format(settings.CRT_STARTREK_URL)
            )

        return csr

    def validate(self, attrs):
        attrs = super().validate(attrs)

        attrs['user'] = self.cerificate_user
        attrs['common_name'] = '{}@smartcard'.format(self.cerificate_user.username)

        return attrs

    def pre_save(self):
        self.validated_data['requester'] = self._context['request'].user
        self.validated_data['requested_by_csr'] = 'request' in self.validated_data
