import re

from rest_framework import serializers


class Vpn1DCertMixin(object):
    common_name_pattern = re.compile(r'^([\w._-]+)@ld\.yandex\.ru$')

    def validate_common_name(self, common_name):
        if common_name and self.common_name_pattern.match(common_name) is not None:
            self.user = self.get_user_from_common_name(common_name)
            return common_name
        else:
            raise serializers.ValidationError('Invalid common name')

    def validate(self, attrs):
        attrs = super().validate(attrs)

        attrs['email'] = self.user.email
        attrs['user'] = self.user
        return attrs

    def pre_save(self):
        self.validated_data['requester'] = self._context['request'].user
        self.validated_data['requested_by_csr'] = 'request' in self.validated_data
