from django.conf import settings
from rest_framework import serializers

from intranet.crt.api.base.serializer_mixins.host import HostsCertMixin, HostsRequiredCertMixin
from intranet.crt.core.models import Host
from intranet.crt.utils.domain import get_domain_levels


class YcServerCertMixin(HostsRequiredCertMixin, HostsCertMixin):
    def postvalidate_common_name(self, attrs):
        self.fill_hosts_with_common_name(attrs)
        return attrs

    def postvalidate_hosts(self, attrs):
        hosts = [h.hostname for h in attrs.get('hosts', [])]

        self.check_required_hosts(hosts)

        for host in hosts:
            domains = set(get_domain_levels(host))
            if not domains & settings.CRT_YC_SERVER_DOMAINS:
                raise serializers.ValidationError('Host not in the white list')

        wildcards = [host for host in hosts if '*' in host]
        if len(wildcards) > 1:
            raise serializers.ValidationError('Выбранный УЦ не поддерживает несколько wildcard.')

        self.fill_common_name_if_not_set(attrs)
        return attrs
