import constance
from rest_framework import serializers

from intranet.crt.api.base.serializer_mixins.personal import PcCertMixin
from intranet.crt.core.models import ZombieCertificate
from intranet.crt.utils.constance import get_values_set_from_str


class ZombieCertMixin(PcCertMixin):
    common_name_pattern = ZombieCertificate.common_name_re
    organizational_unit_pattern = ZombieCertificate.csr_unit_re

    @classmethod
    def is_request_for_market_zombie(cls, common_name, csr):
        try:
            if csr:
                common_name = cls.get_common_name(csr)
            user = cls.get_user_from_common_name(common_name)
            market_zombies = get_values_set_from_str(constance.config.MARKET_ZOMBIES)
        except Exception:
            return False
        return user.username in market_zombies

    def validate_requestee(self, requestee):
        csr = self.context['request'].data.get('request')
        common_name = self.context['request'].data.get('common_name')
        requester = self.context['request'].user
        if (
            requester != requestee
            and
            not (
                requester.has_perm('core.can_issue_device_certificates')
                or
                (
                    self.is_request_for_market_zombie(common_name, csr)
                    and
                    requester.has_perm('core.can_issue_market_zombie_certificates')
                )
            )
        ):
            raise serializers.ValidationError('Invalid user in common name')

    def validate_request(self, csr):
        csr = super(ZombieCertMixin, self).validate_request(csr)

        if csr is None:
            return csr

        common_name = self.get_common_name(csr)
        user = self.get_user_from_common_name(common_name)
        self.validate_requestee(user)

        self.get_organizational_unit(csr, require=True)

        return csr

    def validate(self, attrs):
        attrs = super(ZombieCertMixin, self).validate(attrs)

        if not attrs['user'].is_robot:
            raise serializers.ValidationError('User must be a robot')

        return attrs
